//	CFinderWindow.c

#ifndef _H_CFinderWindow
#define _H_CFinderWindow

#include "ADFS_O_Callbacks.h"
#include "COutlineWindow.h"
#include "CFinderWindowHeader.h"
#include "CRenameTextEdit.h"

class	CEntryArray;
class	CFolder;
class	CDisk;
class	CEntry;

class CFinderWindow : public COutlineWindow {

	public:	Boolean		IFinderWindow(
		ADFS_WindowType			windowType, 
		short					resourceID, 
		O_TopicRef	*topicRef 
	);
	
	virtual	void		DoTopicClick(O_CTopic *cTopic, Point hitPoint, short modifiers);
	virtual	void		PreDraw(void);
	virtual	void		Draw(void);
	virtual	void		PostDraw(long bottom);
	virtual	Boolean		IsIconView(void);
	virtual	void		UpdateMenus(void);
	virtual	Boolean		DoCommand(long command);
	virtual	void		Idle(void);
	virtual	void		DoKeyDown(EventRecord *event);
	virtual	Rect		MarqueeSelect(Point	hitPoint, ulong modifiers);
	
	virtual	OSErr		GetSelectionRgn(RgnHandle theRgn);
	virtual	CEntryArray	*GetDragSelection(void);

			CEntry		*GetFirstEntry(void);
	virtual	void		UpdateSort(Boolean recurseB = TRUE);
	virtual	CEntryArray	*GetSelectedDisks(void);
	virtual	CDisk		*IsDiskSelected(ulong *countP0);
	virtual	CEntryArray	*GetDisksOfSelection(CEntryArray *selectionP);
	virtual	CEntryArray	*GetSelFilesFolders(void);
	virtual	CEntryArray	*GetSelectedFiles(void);
	virtual	CEntry		*IsFileSelected(ulong *countP0);
	virtual	CFolder		*IsFolderSelected(ulong *countP0);
	virtual	CEntryArray	*GetSelection(void);
	virtual	void		DeSelectAll(void);
	Boolean				IsOneEntrySelected(CEntry **entryH);
	virtual	void		UnCacheStats(void);
	ulong				CountSelectedTypes(
		ADFS_O_CBData_COUNT_TYPES *typesP);

	virtual	OSErr		DragTrack(
		DragTrackingMessage		message, 
		DragReference			theDrag);

	virtual	OSErr	DragTrackInWindow(
		DragReference theDrag);

	virtual	OSErr	CanAcceptFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		Boolean			*isGoodFlavorB);

	virtual	OSErr	DragReceiveFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data);

	private:
	typedef	COutlineWindow	_inherited;
};

#endif